<!-- Main content -->
<x-admin.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuOpen>{{ $data['menuOpen'] }} </x-slot:menuOpen>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:page>{{ $data['page'] }}</x-slot:page>
    <x-slot:head>

    </x-slot:head>


    <section class="content">

        <!-- Default box -->
        <div class="row">
            <div class="col-lg-8">
                <x-message></x-message>
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-server text-primary"></i> {{ $data['page'] }}</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered table-hover myTable tab">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th>Nama Toko / Perusahaan</th>
                                    <th>No Telp-</th>
                                    <th>Alamat</th>
                                    <th>Tgl. Input</th>
                                    <th width="20%">Opsi</th>
                                </tr>
                            </thead>
                            <tbody id="view">
                                @forelse ($supplier as $s)
                                    <tr>
                                        <td class="text-center">{{ $no++ }}</td>
                                        <td>{{ $s->nm_supplier }}</td>
                                        <td>{{ $s->hp_supplier }}</td>
                                        <td>{{ $s->alamat_supplier }}</td>
                                        <td>{{ tgl_inf($s->created_at) }} </td>
                                        <td class="text-center">
                                            <button class="btn btn-primary btn-sm mb-0 mt-0 edit"
                                                data-id="{{ $s->id }}" data-toggle="modal"
                                                data-target="#edit{{ $s->id }}">
                                                <i class="fa fa-edit mr-2"></i> Edit
                                            </button>
                                            <button class="btn btn-danger btn-sm mb-0 mt-0 hapus"
                                                data-id="{{ $s->id }}" data-nm="{{ $s->nm_supplier }}">
                                                <i class="fa fa-trash mr-1"></i> Hapus
                                            </button>

                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="10" class="text-center">Data masih kosong</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title "><i class="fa fa-database text-primary"></i> Input {{ $data['page'] }}
                        </h3>
                    </div>
                    <form action="{{ route('supplier.store') }}" method="post">
                        <div class="card-body">
                            @csrf
                            <div class="form-group">
                                <label>Nama Toko / Perusahaan</label>
                                <input type="text" name="nm_supplier" class="form-control"
                                    placeholder="Nama Toko / Perusahaan" autofocus required
                                    value="{{ old('nm_supplier') }}">
                                @error('nm_supplier')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label>No Telp-</label>
                                <input type="text" name="hp_supplier" class="form-control" placeholder="No Telp-"
                                    required value="{{ old('hp_supplier') }}">
                                @error('hp_supplier')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label>Alamat</label>
                                <textarea name="alamat_supplier" id="" placeholder="Alamat.." class="form-control">{{ old('alamat_supplier') }}</textarea>
                                @error('alamat_supplier')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>

                        </div>
                        <div class="card-footer">
                            <button type="reset" class="btn btn-default"><i class="fa fa-sync-alt"></i>
                                Reset</button>
                            <button class="btn btn-primary float-right"><i class="fa fa-save"></i> Simpan</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- /.card -->

    </section>

    @foreach ($supplier as $u)
        <div class="modal fade" id="edit{{ $u->id }}">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header bg-primary ">
                        <h4 class="modal-title">Edit Data</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="{{ route('supplier.edit') }}" method="POST">
                        <div class="modal-body">
                            @csrf
                            @method('put')
                            <input type="hidden" name="id" id="" value="{{ $u->id }}">
                            <input type="hidden" name="hplama" id="" value="{{ $u->hp_supplier }}">
                            <div class="form-group">
                                <label>Nama Toko / Perusahaan</label>
                                <input type="text" name="nm_supplier" class="form-control"
                                    placeholder="Nama Toko / Perusahaan" autofocus required
                                    value="{{ $u->nm_supplier }}">
                                @error('nm_supplier')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label>No Telp-</label>
                                <input type="text" name="hp_supplier" class="form-control" placeholder="No Telp-"
                                    required value="{{ $u->hp_supplier }}">
                                @error('hp_supplier')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label>Alamat</label>
                                <textarea name="alamat_supplier" id="" placeholder="Alamat.." class="form-control">{{ $u->alamat_supplier }}</textarea>
                                @error('alamat_supplier')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>

                        </div>
                        <div class="modal-footer justify-content-between">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Simpan</button>
                        </div>
                    </form>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
    @endforeach

    <x-slot:foot>

        <script src="{{ asset('') }}assets/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script>
            $('#view').on('click', '.hapus', function() {
                var id = $(this).attr('data-id');
                var nama = $(this).attr('data-nm');

                Swal.fire({
                    title: "Apa anda yakin?",
                    text: "Supplier  ( " + nama +
                        " ) & data yang berkaitan dengan Supplier tersebut akan di hapus!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Ya, Hapus!"
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.location.href = "delete-supplier/" + id;
                    }
                });

            });
        </script>
    </x-slot:foot>
</x-admin.contents>
